# TFS checked in - 1/25/2016 jbucci 

codecols = c("chartreuse3","darkgoldenrod2","deepskyblue2","firebrick2")
codecols2 = c("chartreuse3","darkgoldenrod2","deepskyblue2","firebrick2","darkorchid1","tan","slateblue3","forestgreen","coral","gray48",
              "aquamarine","bisque2","blue3","blueviolet","brown2","burlywood3","darkgoldenrod4","cyan3","cornflowerblue",
              "chocolate2","chartreuse1","darkorange","darkorchid4","darkred","darkslateblue","darkturquoise","deeppink1",
              "deeppink4","gray7","gold1","dodgerblue1")
codecols2 = c(codecols2,colors())


####### function to harmonize reference levels with actual columns of annot:
# if a reference level isn't present, re-assign it to the most similar level:
harmonize.reference.levels = function(sampleannot.variables,sampleannot.variabletypes,sampleannot.referencelevels,annot)
{
  names(sampleannot.variabletypes) = names(sampleannot.referencelevels) = sampleannot.variables
  
  # for each non-NA ref level, is it present?
  for(i in 1:ncol(annot))
  {
    tempvarname = colnames(annot)[i]
    # if it's categorical:
    if(sampleannot.variabletypes[tempvarname]=="categorical")
    {
      # and if the ref level isn't a match:
      if(!is.element(sampleannot.referencelevels[tempvarname],unique(annot[,tempvarname])))
      {
        ref0 = sampleannot.referencelevels[tempvarname]
        # if it looks like a numeric ref level:
        if(!is.na(as.numeric(ref0)))
        {
          # look for the same number amongst the levels of the variable:
          levels0 = as.numeric(as.character(unique(annot[,tempvarname])))
          closestlevel = order(abs(as.numeric(ref0) - levels0))[1]
          replacelevel = levels0[closestlevel]
          sampleannot.referencelevels[tempvarname] = replacelevel
          warning(paste("Assigned reference level",ref0,"had no match in the data.  It is being reassigned to the most similar observed level,",replacelevel))
        }
        # and if it's not a numeric reference level:
        if(is.na(as.numeric(ref0)))
        {
          stop(paste("Assigned reference level",ref0,"had no match in the data, and we were unable to guess which level should be used in its place"))
        }
      }
    }
  }
  return(sampleannot.referencelevels)
}



#### function to turn a named vector with semicolon-separated entries into a matrix of 1s and 0s:
annotcolumntomatrix = function(x)
{
  # remove spaces after semicolons:
  for(i in 1:5){x = gsub("; ",";",x)}
  # split the vector into a list:
  vals = list()
  uniquevals = c()
  for(i in 1:length(x))
  {
    vals[[i]] = unlist(strsplit(x[i],";"))
    uniquevals = union(uniquevals,vals[[i]])
  }
  uniquevals = uniquevals[order(uniquevals)]
  uniquevals = setdiff(uniquevals,NA)
  # create the matrix:
  mat = matrix(0,length(x),length(uniquevals))
  dimnames(mat) = list(names(x),uniquevals)
  for(i in 1:length(x))
  {
    if(length(intersect(colnames(mat),vals[[i]]))>0){mat[i,intersect(colnames(mat),vals[[i]])] = 1}
  }
  return(mat)
}


##############################################
# functions for data library management

downloadpackages <- function(sourceLocation, libraryLocation)
{
  #windows or Mac?
  osName = Sys.info()['sysname']
  
  site = "http://cran.us.r-project.org"  
  #checks if package is installed; if not, function downloads the library from the web
  NSL   <- cbind(read.table(paste(sourceLocation,'//pckg_v_list.csv',sep=''), header = FALSE, sep = ','), Installed = 0, packageVersionInstalled = "r")
  existing.packages <- installed.packages(libraryLocation)
  if(nrow(existing.packages)>0)
    userL <- subset(existing.packages, select = c(Package, Version))
 
  NSL[,sapply(NSL,class)=="factor"] <- as.data.frame(sapply(NSL[,sapply(NSL,class)=="factor"],function(x) as.character(x) ),stringsAsFactors = F)

  for (i in seq(1,length(NSL[,1]))){
    if(nrow(existing.packages)>0){
      for (j in seq(1,length(userL[,1]))){
        if (NSL[i,1]==userL[j,1]){
          NSL[i,5] = as.character(packageVersion(as.character(NSL[i,1])))
          
          #if the version matches OR it's a downloaded package - it's installed
          #for our LIBS packages - version must be an exact match
          if (NSL[i,2]==userL[j,2] || NSL[i,3]!="LIBS") {
            NSL[i,4]=1
            cat(paste(NSL[i,1]," is already installed.",sep=''),file=log,sep='\n',append=TRUE)
          } else {
            cat(paste(NSL[i,1]," is already installed, but a newer version will be installed.",sep=''),file=log,sep='\n',append=TRUE)
          }
          
          break
        }
      }
    }

    if (NSL[i,4]==0){
      if(!testCon()){
        cat("document.write('<p><b>- The analysis was stopped -</b></p>');", file=paste(path.inc,"//status.js",sep=""), append=TRUE)
        cat("document.write('<hr/>');", file=paste(path.inc,"//status.js",sep=""), append=TRUE)
        cat("document.write('<p><b>nSolver was unable to download the required R libraries. There may be a problem with your internet connection.</b></p>');", file=paste(path.inc,"//status.js",sep=""), append=TRUE)
        cat("document.write('<p>In some cases, running the analysis again may succeed. You can manually download the required libraries by clicking the link below:</p>');", file=paste(path.inc,"//status.js",sep=""), append=TRUE)
        
        if (osName == 'Windows') {
          cat("document.write('<p><a href=\"http://www.nanostring.com/products/nSolver/archive/windows_packages.zip\">Download R Libraries for Windows</a></p>');", file=paste(path.inc,"//status.js",sep=""), append=TRUE)
        }
        else if (osName == 'Darwin') {
          cat("document.write('<p><a href=\"http://www.nanostring.com/products/nSolver/archive/mac_packages.zip\">Download R Libraries for Mac</a></p>');", file=paste(path.inc,"//status.js",sep=""), append=TRUE)
        }
        
        cat("document.write('<hr/>');", file=paste(path.inc,"//status.js",sep=""), append=TRUE)
        
        stop("Packages cannot be downloaded without internet connection - analysis stopped")
      }
      suppressMessages(source("http://bioconductor.org/biocLite.R"))
      suppressMessages(biocLite(lib = libraryLocation, suppressUpdates=TRUE, suppressAutoUpdate=TRUE))
      if (NSL[i,3]=="BC"){
        suppressMessages(suppressWarnings(biocLite(paste(NSL[i,1],sep=''), lib = libraryLocation, suppressUpdates=TRUE, suppressAutoUpdate=TRUE)))
        cat(paste(NSL[i,1]," is now installed.",sep=''),file=log,sep='\n',append=TRUE)
      }
      if (NSL[i,3]=="CRAN"){
        suppressMessages(install.packages(paste(NSL[i,1],sep=''), repos = site, quiet = TRUE, lib = libraryLocation, dependencies = T))
        cat(paste(NSL[i,1]," is now installed.",sep=''),file=log,sep='\n',append=TRUE)
      }
      if (NSL[i,3]=="LIBS"){
        if (osName == 'Windows') {
          suppressMessages(install.packages(path.expand(file.path(sourceLocation, paste(NSL[i,1], '_', NSL[i,2], '.zip', sep=''))), lib = libraryLocation))
        }
        else if (osName == "Darwin") {
          suppressMessages(install.packages(path.expand(file.path(sourceLocation, paste(NSL[i,1], '_', NSL[i,2], '.tgz', sep=''))), repos=NULL, lib = libraryLocation))
        }
        cat(paste(NSL[i,1]," is now installed.",sep=''),file=log,sep='\n',append=TRUE)
      }
    }
    if(i%%5==0||i%%length(NSL[,1])==0){cat(paste("document.write('<p>Loaded ",i,"/",length(NSL[,1])," libraries</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)}
  }
  for (i in seq(1,length(NSL[,1]))){
    if(nrow(existing.packages)>0){
      for (j in seq(1,length(userL[,1]))){
        if (NSL[i,1]==userL[j,1]){
          NSL[i,4]=1
          NSL[i,5] = as.character(packageVersion(as.character(NSL[i,1]), lib.loc = libraryLocation))
          cat(paste(NSL[i,1]," is already installed.",sep=''),file=log,sep='\n',append=TRUE)
          break
        }
      }
    }
    
  }
  write.csv(NSL, paste(sourceLocation,'//pckg_v_list_comparison_',getRversion(),'.csv',sep=''))
}


requirelibraries = function(sourceLocation)
{
#  suppressMessages(require(NormqPCR))
#  suppressMessages(require(gplots))
#  suppressMessages(require(pathview))
#  suppressMessages(require(pathifier))
#  suppressMessages(require(xtable))  
#  suppressMessages(require(deming, lib.loc = .libPaths()))
#  suppressMessages(require(mclust, lib.loc = .libPaths()))

  NSL <- read.table(paste(sourceLocation,'//pckg_v_list.csv',sep=''), header = FALSE, sep = ',')
  
  #Don't attach pathview related packages and rClr
  #-----------------------------------------------
  libs.no.attach <- c("package:pathview","package:org.Hs.eg.db",  "package:RSQLite","package:DBI", "package:AnnotationDbi", "package:GenomeInfoDb",
                        "package:IRanges","package:S4Vectors","package:Biobase","package:BiocGenerics","package:parallel","package:stats4","package:KEGGgraph",
                        "package:graph", "package:XML", "package:rClr")
  NSL <- NSL[!NSL$V1 %in% gsub("package:",replacement = "",libs.no.attach),]
  
  for(i in 1:dim(NSL)[1]){
    suppressMessages(require(noquote(NSL[i,1]), lib.loc = .libPaths(), character.only = T))
  }
}


runloadlibraries = function(){
  print("Starting loading R libraries")  
  cat("LOG:Starting loading R libraries",file=log,sep='\n\n',append=TRUE)
  cat("document.write('<p>Starting loading R libraries</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
  
  ### install packages and load libraries
  path.source.libs = paste(path.pipeline.base, "libs", sep="/")
  
  osName <- Sys.info()['sysname']
  path.libs <- ""
  
  if(osName == "Windows"){
    path.libs = normalizePath(paste(Sys.getenv("ProgramData"), "nSolverAA_Rlibs", sep="/"))
  }
  else if (osName == "Darwin") {
    path.libs = "~/Library/nSolverAA_Rlibs";
  }
  
  dir.create(path.libs,showWarnings = F)
  .libPaths(c( path.libs,.libPaths()) )
    
  cat("installing libraries",file=log,sep='\n',append=TRUE)
  downloadpackages(sourceLocation=path.source.libs,  libraryLocation=path.libs)
  
  cat("loading libraries",file=log,sep='\n',append=TRUE)
  requirelibraries(sourceLocation = path.source.libs)
}




#############################################################
### function to draw a plot using any desired output type
drawplot = function(filename,type = c("png","pdf","tiff","jpg","bmp"),width = 1, height = 1,heatmapres=FALSE)
{
  # modify filename to remove illegal characters:
  illegalcharacters = c("<",">",":","\"","\\?","\\|","\\*")  #
  # only work on the later part of the filename after the "C://":
  filename1 = substr(filename,1,4)
  filename2 = substr(filename,5,length(strsplit(filename,split="")[[1]]))
  for(i in 1:length(illegalcharacters))
  {
    filename2 = gsub(illegalcharacters[i],"_",filename2);  #print(illegalcharacters[i]); print(filename2)
  }
  filename = paste(filename1,filename2,sep="")
  # modify resolution for heatmaps:
  res = NA; pointsize = 12
  if(heatmapres){res = 200;pointsize = 7}
  
  # run plotting function:
  if(type=="png")
  {
    png(filename=paste(filename,type,sep="."),width=480*width,height=480*height,res=res,pointsize=pointsize)
  }
  if(type=="jpg")
  {
    jpeg(filename=paste(filename,type,sep="."),width=480*width,height=480*height)
  }
  if(type=="bmp")
  {
    bmp(filename=paste(filename,type,sep="."),width=480*width,height=480*height)
  }
  if(type=="pdf")
  {
    pdf(file=paste(filename,type,sep="."),width=7*width,height=7*height)
  }
  if(type=="tiff")
  {
    tiff(filename=paste(filename,type,sep="."),width=480*width,height=480*height)
  }
  return(filename) 
}
##### function to correct an illegal filename:
correct.filename = function(filename)
{
  # modify filename to remove illegal characters:
  illegalcharacters = c("<",">",":","\"","\\?","\\|","\\*")  
  # only work on the later part of the filename after the "C://":
  filename1 = substr(filename,1,4)
  filename2 = substr(filename,5,length(strsplit(filename,split="")[[1]]))
  for(i in 1:length(illegalcharacters))
  {
    filename2 = gsub(illegalcharacters[i],"_",filename2);  #print(illegalcharacters[i]); print(filename2)
  }
  filename = paste(filename1,filename2,sep="")
  return(filename)
}




##############################################
# function for data reading and cleaning
# load.and.clean.data = function(path.data,path.sampleannot,path.geneannot,
#                                prunegenes.run,prunegenes.bg.level,prunegenes.missing.freq,
#                                min.sample.covariate,gene.annotation.id.column,gene.set.column,sample.annotation.id.column,   #<------- right now min.sample.covariate does nothing
#                                sampleannot.variables,sampleannot.variabletypes,sampleannot.referencelevels,draw.color.legend,min.samples,min.gene.set.size,plottypearg)
# {
#   # start warnings paragraph:
#   warnings.paragraph = ""
#   ##### apply make.names() to arguments that are column headers:
#   if(length(sampleannot.variables)>0){sampleannot.variables=make.names(sampleannot.variables)}
#   #  if(length(deregmodule.arg.is.normal.variable)>0){deregmodule.arg.is.normal.variable=make.names(deregmodule.arg.is.normal.variable)}
#   #  if(length(deregmodule.arg.covariates)>0){deregmodule.arg.covariates=make.names(deregmodule.arg.covariates)}
#   #  if(length(deregmodule.arg.adjust.for)>0){deregmodule.arg.adjust.for=make.names(deregmodule.arg.adjust.for)}
#   #  if(length(DEmodule.arg.predictors)>0){DEmodule.arg.predictors=make.names(DEmodule.arg.predictors)}
#   #  if(length(DEmodule.arg.confounders)>0){DEmodule.arg.confounders=make.names(DEmodule.arg.confounders)}
#   
#   
#   ##### load data and annotation:
#   cat("loading annotation files",file=log,sep='\n\n',append=TRUE)
#   # load w/o row.names
#   #annot = read.csv(path.sampleannot,row.names=sample.annotation.id.column) 
#   annot = read.csv(path.sampleannot,row.names=sample.annotation.id.column,colClasses="character")  #<---- changed 6-16
#   cat("loading gene annotation files",file=log,sep='\n\n',append=TRUE)
#   
#   gannot = read.csv(path.geneannot)
#   suppressWarnings(write.table(gannot[1:5,1:5],file=log,sep='\t',append=TRUE))
#   gannot.remove = !is.element(tolower(gannot$Class.Name),c("endogenous","housekeeping", "protein", "protein_neg"))
#   cat(paste(table(gannot.remove),sep='\t'),file=log,sep='\n',append=TRUE)
#   cat(paste(summary(gannot.remove),sep='\t'),file=log,sep='\n',append=TRUE)
#   gannot = gannot[!gannot.remove,]
#   
#   # 10/19/2015 - JBUCCI: need to deal with protein names that carry parentheses; ignored make.names() function
#   dimnames(gannot)[[1]] = as.character(gannot[,gene.annotation.id.column])   #make.names(gannot[,gene.annotation.id.column])
#   
#   # for cancer pathways panel analyses, all NA gene annotation values can be set to 0:
#   replace.gannot.NA.with.0 = TRUE
#   if(replace.gannot.NA.with.0){ gannot = suppressWarnings(replace(gannot,is.na(gannot),0)) }   #<--------- returns a warning, but probably OK
#   cat("loaded gene annotation",file=log,sep='\n\n',append=TRUE)
#   
#   cat("loading data",file=log,sep='\n\n',append=TRUE)
#   if(!exists("data.type")){data.type = "normalized"}   
#   if(data.type=="normalized"){raw = read.csv(path.data[1],row.names=1,check.names=F)}
#   if(data.type=="raw"){raw = read.csv(path.data[2],row.names=1,check.names=F)}
#   
#   ###
#   # JBUCCI - 10/27/2015 separate mRNA and protein data for now
#   # grepl("PROTEIN", toupper(l))
#   # length(as.character(gannot$Gene.Name[which(grepl("PROTEIN", toupper(gannot$Class.Name)) == T)]))
#   # gannot$Gene.Name[which(grepl("PROTEIN", toupper(gannot$Class.Name)) == T)]
#   
#   raw.mRNA <- raw[,as.character(gannot$Gene.Name[which(grepl("PROTEIN", toupper(gannot$Class.Name)) == F)])]
#   raw.prot <- raw[,as.character(gannot$Gene.Name[which(grepl("PROTEIN", toupper(gannot$Class.Name)) == T)])]
#   
#   ###
#   
#   # make raw use the same gene names variable as gannot:   <--------------
#   
#   ## screen out low-count genes:
#   pruneflag=FALSE
#   if((data.type=="raw")&prunegenes.run)
#   {
#     pruneflag=TRUE
#     prune = apply((raw.mRNA<prunegenes.bg.level),2,mean,na.rm=T)>prunegenes.missing.freq
#     prune[is.na(prune)]=TRUE
#     if(mean(prune)>0.8)
#     {
#       pruneflag=FALSE
#       warning("Warning: More than 80% of genes were pruned using these cutoffs - retaining all genes")
#       cat("LOG:Warning: More than 80% of genes were pruned using these cutoffs - retaining all genes",file=log,sep='\n',append=TRUE)
#       warnings.paragraph = paste(warnings.paragraph,"Warning: More than 80% of genes were pruned using the given cutoffs - retaining all genes","\n")
#       prune = FALSE
#     }
#     prunedgenes = suppressWarnings(as.matrix(dimnames(raw.mRNA)[[2]][prune])); 
#     colnames(prunedgenes)=paste("The below genes were removed for falling below the background level of",
#                                 prunegenes.bg.level,"with frequency greater than",prunegenes.missing.freq)
#     write.csv(as.matrix(prunedgenes),file="genes removed for low signal.csv",row.names=FALSE)
#     #raw.mRNA = raw.mRNA[,!prune]
#   }else{
#     prune = rep(FALSE,ncol(raw.mRNA)); names(prune) = colnames(raw.mRNA)
#   }
#   
#   
#   cat("dimensions of gannot:",file=log,sep='\n',append=TRUE)
#   cat(dim(gannot),file=log,sep='\n',append=TRUE)
#   cat("dimensions of annot:",file=log,sep='\n',append=TRUE)
#   cat(dim(annot),file=log,sep='\n',append=TRUE)
#   cat("dimensions of raw.mRNA:",file=log,sep='\n',append=TRUE)
#   cat(dim(raw.mRNA),file=log,sep='\n',append=TRUE)
#   
#   ## exit if raw.mRNA has only one sample:
#   if(dim(raw.mRNA)[1]<min.samples)
#   {
#     stop(paste("Less than",min.samples," samples were included in the analysis.  Re-run with multiple samples."))
#   }
#   
#   print("Loaded user files")  
#   cat("LOG:Loaded user files",file=log,sep='\n\n',append=TRUE)
#   #cat("document.write('<p>Loaded user files</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
#   names(sampleannot.variabletypes)=sampleannot.variables
#   #plottypearg = unique(c("png",plottypearg))
#   
#   
#   print("Finished setup; starting annotations and data checking")
#   cat("LOG:Finished setup; starting annotations and data checking",file=log,sep='\n\n',append=TRUE)
#   
#   ## check that sample annot and raw.mRNA data have same set of sampleIDs:
#   idintersect = intersect(dimnames(raw.mRNA)[[1]],dimnames(annot)[[1]])
#   cat("Samples in annotation omitted from dataset:",file=log,sep='\n',append=TRUE)
#   suppressWarnings(write.table(setdiff(dimnames(annot)[[1]],dimnames(raw.mRNA)[[1]]),file=log,sep='\t',append=TRUE))
#   cat("Samples in dataset omitted from annotation:",file=log,sep='\n',append=TRUE)
#   suppressWarnings(write.table(setdiff(dimnames(raw.mRNA)[[1]],dimnames(annot)[[1]]),file=log,sep='\t',append=TRUE))
#   
#   ## re-order sample annotation matrix to match data matrix:
#   annot = annot[idintersect,,drop=FALSE]
#   raw.mRNA = raw.mRNA[idintersect,,drop=FALSE]
#   
#   ### remove the controls from the raw.mRNA data matrix:
#   controlnames = c(paste("Pos",c("A","B","C","D","E","F"),sep="_"),paste("Neg",c("A","B","C","D","E","F","G","H"),sep="_"))
#   raw.mRNA = raw.mRNA[,!is.element(dimnames(raw.mRNA)[[2]],controlnames)]
#   
#   if(!identical(dimnames(raw.mRNA)[[1]],dimnames(annot)[[1]])){
#     cat("LOG:Warning: Sample IDs in sample annotation file don't mathc sample IDs in expression dataset",file=log,sep='\n',append=TRUE)
#     stop("Error: Sample IDs in sample annotation file don't match sample IDs in expression dataset")
#   }
#   
#   ### format sample annot:
#   cat("formatting annotation data frame",file=log,sep='\n',append=TRUE)
#   suppressWarnings(write.table(head(annot),file=log,sep='\t',append=TRUE))
#   cat(sampleannot.variables,file=log,sep='\n',append=TRUE)
#   # make sure no variables that aren't in annot get called later:
#   #deregmodule.arg.is.normal.variable = intersect(sampleannot.variables,deregmodule.arg.is.normal.variable)
#   #deregmodule.arg.covariates = intersect(sampleannot.variables,deregmodule.arg.covariates)
#   #deregmodule.arg.adjust.for = intersect(sampleannot.variables,deregmodule.arg.adjust.for)
#   #DEmodule.arg.predictors = intersect(sampleannot.variables,DEmodule.arg.predictors)
#   #DEmodule.arg.confounders = intersect(sampleannot.variables,DEmodule.arg.confounders)
#   
#   sampleannot.referencelevels = as.character(sampleannot.referencelevels)  
#   
#   annotdimnames = dimnames(annot)
#   # 1st, take only variables declared by nSolver:
#   annot = annot[,sampleannot.variables,drop=FALSE]  
#   if(length(sampleannot.variables==1)){dimnames(annot)[[2]] = sampleannot.variables}
#   
#   
#   # added 6-16: recode continuous variables as continuous.  might be rendundant with code lower down.
#   for(i in 1:ncol(annot))
#   {
#     if(sampleannot.variabletypes[colnames(annot)[i]]=="continuous")
#     {
#       annot[,i] = as.numeric(as.character(annot[,i]))
#     }
#   }
#   
#   ## harmonize any reference levels that don't show up in the data:
#   sampleannot.referencelevels = harmonize.reference.levels(sampleannot.variables,sampleannot.variabletypes,sampleannot.referencelevels,annot)
#   
#   ### check that all sample annot variables have variability
#   # 1st identify the ones that we need to remove:
#   vars.to.remove = vars.to.remove.TF = rep(NA,length(sampleannot.variables))
#   for(i in 1:length(sampleannot.variables))
#   {
#     cat(sampleannot.variables[i],file=log,sep='\n',append=TRUE)
#     cat(table(annot[,sampleannot.variables[i]]),file=log,sep='\n',append=TRUE)
#     vars.to.remove.TF[i]=FALSE
#     vunique=setdiff(unique(annot[,sampleannot.variables[i]]),NA)
#     nunique = length(setdiff(unique(annot[,sampleannot.variables[i]]),NA))
#     if(nunique<2)
#     {
#       print(paste("Warning:",sampleannot.variables[i],"has fewer than 2 unique, non-missing values.  It will be removed from all subsequent analyses."))
#       cat(paste("LOG:Warning:",sampleannot.variables[i],"has fewer than 2 unique, non-missing values.  It will be removed from all subsequent analyses."),file=log,sep='\n',append=TRUE)
#       warnings.paragraph = paste(warnings.paragraph,"Warning:",sampleannot.variables[i],"has fewer than 2 unique, non-missing values.  It will be removed from all subsequent analyses.","\n")
#       
#       #cat(paste("document.write('<p>Warning: ",sampleannot.variables[i],"has fewer than 2 unique, non-missing values.  It will be removed from all subsequent analyses.</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
#       vars.to.remove[i] = c(sampleannot.variables[i])
#       vars.to.remove.TF[i]=TRUE
#     }
#     if((sampleannot.variabletypes[i]=="categorical")&(max(abs(table(annot[,sampleannot.variables[i]])-1))==0))
#     {
#       print(paste("Warning: categorical variable",sampleannot.variables[i],"has as many values as observations.  It will be removed from all subsequent analyses."))
#       cat(paste("LOG:Warning: categorical variable",sampleannot.variables[i],"has as many values as observations.  It will be removed from all subsequent analyses."),file=log,sep='\n',append=TRUE)
#       warnings.paragraph = paste(warnings.paragraph,"Warning: categorical variable",sampleannot.variables[i],"has as many values as observations.  It will be removed from all subsequent analyses.","\n")
#       #cat(paste("document.write('<p>Warning: categorical variable",sampleannot.variables[i],"has as many values as observations.  It will be removed from all subsequent analyses.</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
#       vars.to.remove[i] = c(sampleannot.variables[i])
#       vars.to.remove.TF[i]=TRUE
#     }
#     #make sure continuous variables are numbers
#     if(sampleannot.variabletypes[i]=="continuous")
#     {
#       for(j in 1:nunique){
#         if(!is.numeric(vunique[[j]])){
#           print(paste("Warning: continuous variable",sampleannot.variables[i],"has non-numeric values.  It will be removed from all subsequent analyses."))
#           cat(paste("LOG:Warning: continuous variable",sampleannot.variables[i],"has non-numeric values.  It will be removed from all subsequent analyses."),file=log,sep='\n',append=TRUE)
#           warnings.paragraph = paste(warnings.paragraph,"Warning: continuous variable",sampleannot.variables[i],"has non-numeric values.  It will be removed from all subsequent analyses.","\n")
#           #cat(paste("document.write('<p>Warning: continuous variable",sampleannot.variables[i],"has non-numeric values.  It will be removed from all subsequent analyses.</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
#           vars.to.remove[i] = c(sampleannot.variables[i])
#           vars.to.remove.TF[i]=TRUE
#           break
#         }
#       }
#     }
#     # make sure boolean variables are well-formatted:
#     if(sampleannot.variabletypes[i]=="boolean")
#     {
#       annot[,sampleannot.variables[i]] = toupper(annot[,sampleannot.variables[i]])
#       # make sure it's actually boolean
#       nonbooleanlevels = setdiff(unique(annot[,sampleannot.variables[i]]),c("FALSE","TRUE",NA))
#       if(length(nonbooleanlevels)>0)
#       {
#         warning(paste("Warning: Boolean variable",sampleannot.variables[i],"has illegal value(s)",nonbooleanlevels,".  It is being dropped from the analysis."))
#         cat(paste("LOG: Warning: Boolean variable",sampleannot.variables[i],"has illegal value(s)",nonbooleanlevels,".  It is being dropped from the analysis."),file=log,sep='\n',append=TRUE)
#         warnings.paragraph = paste(warnings.paragraph,"Warning: Boolean variable",sampleannot.variables[i],"has illegal values.  It will be removed from all subsequent analyses.","\n")
#         #cat(paste("document.write('<p> Warning: Boolean variable",sampleannot.variables[i],"has illegal value(s)",nonbooleanlevels,".  It is being dropped from the analysis)</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
#         vars.to.remove[i] = c(sampleannot.variables[i])
#         vars.to.remove.TF[i]=TRUE
#       }
#     }
#   }
#   
#   cat("vars to remove:",file=log,sep='\n',append=TRUE)
#   suppressWarnings(write.table(vars.to.remove,file=log,sep='\t',append=TRUE))
#   suppressWarnings(write.table(vars.to.remove.TF,file=log,sep='\t',append=TRUE))
#   # now remove them:
#   for(i in length(sampleannot.variables):1)
#   {
#     if(vars.to.remove.TF[i])
#     {
#       # 1st clean up other arguments using the variable:
#       deregmodule.arg.is.normal.variable = setdiff(deregmodule.arg.is.normal.variable,sampleannot.variables[i])
#       if(length(deregmodule.arg.is.normal.variable)==0)
#       {
#         deregmodule.arg.is.normal.level=NULL
#         if(deregmodule.arg.method=="Pathifier"){deregmodule.arg.method="none"}
#       }
#       deregmodule.arg.covariates = setdiff(deregmodule.arg.covariates,sampleannot.variables[i])
#       deregmodule.arg.adjust.for = setdiff(deregmodule.arg.adjust.for,sampleannot.variables[i])
#       DEmodule.arg.predictors = setdiff(DEmodule.arg.predictors,sampleannot.variables[i])
#       DEmodule.arg.confounders = setdiff(DEmodule.arg.confounders,sampleannot.variables[i])
#       if(length(DEmodule.arg.predictors)==0)
#       {
#         DEmodule.arg.run=FALSE
#         pathviewmodule.arg.run=FALSE
#         gsamodule.arg.run = FALSE
#       }
#       
#       sampleannot.variables=sampleannot.variables[-i]
#       sampleannot.variabletypes=sampleannot.variabletypes[-i]
#       sampleannot.referencelevels=sampleannot.referencelevels[-i] 
#       annot = annot[,-i,drop=FALSE]; ##**
#       #dimnames(annot)[[2]] = sampleannot.variables; dimnames(annot)[[1]] = annotdimnames[[1]]
#     }
#   }
#   
#   
#   cat("sampleannot.variables:",file=log,sep='\n',append=TRUE)
#   suppressWarnings(write.table(sampleannot.variables,file=log,sep='\t',append=TRUE))
#   cat("sampleannot.variabletypes:",file=log,sep='\n',append=TRUE)
#   suppressWarnings(write.table(sampleannot.variabletypes,file=log,sep='\t',append=TRUE))
#   cat("sampleannot.variabletypes:",file=log,sep='\n',append=TRUE)
#   suppressWarnings(write.table(sampleannot.variabletypes,file=log,sep='\t',append=TRUE))
#   
#   # make all variables cat or cont as declared, and set appropriate ref levels when given:  
#   if(length(sampleannot.variables)>0)
#   {  
#     for(i in 1:length(sampleannot.variables))
#     {
#       suppressWarnings(write.table(sampleannot.variables[i],file=log,sep='\t',append=TRUE))
#       suppressWarnings(write.table(sampleannot.variabletypes[i],file=log,sep='\t',append=TRUE))
#       
#       if(sampleannot.variabletypes[i]=="continuous")
#       {
#         annot[,sampleannot.variables[i]]=as.numeric(as.vector(annot[,sampleannot.variables[i]]))
#         cat("as.numeric(as.vector(annot[,sampleannot.variables[i]]))",file=log,sep='\n',append=TRUE)
#         suppressWarnings(write.table(head(annot[,sampleannot.variables[i]]),file=log,sep='\t',append=TRUE))
#         if(var(annot[,sampleannot.variables[i]],na.rm=T)==0)
#         {
#           warning(paste(sampleannot.variables[i],"had zero variance.  It is being dropped from the analysis.")) 
#           cat(paste("LOG: Warning: ", sampleannot.variables[i],"had zero variance.  It is being dropped from the analysis."),file=log,sep='\n',append=TRUE)
#           warnings.paragraph = paste(warnings.paragraph,"Warning: ",sampleannot.variables[i],"has zero variance.  It will be removed from all subsequent analyses.","\n")
#           
#           #cat(paste("document.write('<p>Warning: ", sampleannot.variables[i],"had zero variance.  It is being dropped from the analysis</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
#           annot = annot[,-sampleannot.variables[i],drop=FALSE]  ##**
#         }
#       }
#       if(sampleannot.variabletypes[i]=="categorical")
#       {
#         ### order the factor levels alphabetically, but require that the first be the declared reference level:
#         # get the values the variable takes, and place them alphabetically:
#         levels = unique(as.character(annot[,sampleannot.variables[i]]))
#         levels = levels[order(levels)]
#         # if a reference level is declared, make it first:
#         if(!is.na(sampleannot.referencelevels[i]))
#         {
#           levels = setdiff(levels,sampleannot.referencelevels[i])
#           levels = c(sampleannot.referencelevels[i],levels)
#         }
#         #print(sampleannot.variables[])
#         annot[,sampleannot.variables[i]]=factor(as.character(annot[,sampleannot.variables[i]]),levels=levels)  
#         #if(!is.na(sampleannot.referencelevels[i]))
#         #{
#         #  annot[,sampleannot.variables[i]]=relevel(annot[,sampleannot.variables[i]],sampleannot.referencelevels[i])
#         #}
#         #        if(length(unique(annot[,sampleannot.variables[i]]))==1)
#         #        {
#         #          warning(paste("Warning: ",sampleannot.variables[i],"has only one level.  It is being dropped from the analysis."))
#         #          cat(paste("LOG: Warning: ", sampleannot.variables[i],"has only one level.  It is being dropped from the analysis."),file=log,sep='\n',append=TRUE)
#         #          #cat(paste("document.write('<p>Warning: ", sampleannot.variables[i],"has only one level.  It is being dropped from the analysis</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
#         #          annot = annot[,-sampleannot.variables[i],drop=FALSE]  ##**
#         #        }
#       }
#       # if boolean: treat is as categorical, w FALSE as the reference:
#       if(sampleannot.variabletypes[i]=="boolean")
#       {
#         # make it uppercase
#         annot[,sampleannot.variables[i]] = toupper(annot[,sampleannot.variables[i]])
#         sampleannot.variabletypes[i]="categorical"
#         annot[,sampleannot.variables[i]]=as.factor(as.character(annot[,sampleannot.variables[i]]))
#         annot[,sampleannot.variables[i]]=relevel(annot[,sampleannot.variables[i]],"FALSE")
#       }
#     }
#   }
#   
#   ## save current "original" annot, then replace its categorical variables with values w legal names:  #<--- new 7-13. not doing anything yet
#   #annot.orig = annot
#   #for(i in 1:ncol(annot))
#   #{
#   #  if(sampleannot.variabletypes[colnames(annot)[i]]=="categorical")
#   #  {
#   #    oldvals = as.character(annot[,i])
#   #    newvals = make.names(oldvals)
#   #  }
#   #}
#   
#   print(sampleannot.referencelevels)
#   
#   cat("dim(raw.mRNA)=",file=log,sep='\n',append=TRUE)
#   cat(dim(raw.mRNA),file=log,sep='\n',append=TRUE)
#   cat("dim(annot)=",file=log,sep='\n',append=TRUE)
#   cat(dim(annot),file=log,sep='\n',append=TRUE)
#   cat("dim(gannot)=",file=log,sep='\n',append=TRUE)
#   cat(dim(gannot),file=log,sep='\n',append=TRUE)
#   
#   # remove all but endogenous and housekeeping genes from gannot:
#   cat("top of gannot",file=log,sep='\n',append=TRUE)
#   suppressWarnings(write.table(gannot[1:5,1:5],file=log,sep='\t',append=TRUE))
#   
#   # final alignment of raw, annot, gannot:
#   intersect.sample = intersect(dimnames(raw.mRNA)[[1]],dimnames(annot)[[1]])
#   intersect.gene = intersect(dimnames(raw.mRNA)[[2]],dimnames(gannot)[[1]])
#   raw.mRNA = raw.mRNA[intersect.sample,intersect.gene,drop=FALSE]
#   
#   ##### 
#   # 10/27/2015 - jbucci - one solution: merge raw.protein back with pruned raw.mRNA
#   
#   intersect.protein = intersect(dimnames(raw.prot)[[2]],dimnames(gannot)[[1]])
#   raw.prot = raw.prot[intersect.sample,intersect.protein,drop=FALSE]
#   
#   #rowMatch <- match(rownames(raw.mRNA), rownames(raw.prot))
#   #rowMatch
#   
#   #raw <- cbind(raw.mRNA, raw.prot[rowMatch,])
#   #head(raw)
#   #dim(raw)
#   
#   #####
#   
#   annot = annot[intersect.sample,,drop=FALSE]
#   gannot = gannot[c(intersect.gene,intersect.protein),,drop=FALSE]
#   prune = prune[intersect.gene]
#   print(dim(raw.mRNA)); print(dim(raw.prot)); print(dim(gannot))
#   
#   ## re-order data matrix to match gene annotation matrix:
#   cat("top of raw",file=log,sep='\n',append=TRUE)
#   suppressWarnings(write.table(raw[1:5,1:5],file=log,sep='\t',append=TRUE))
#   cat("dim(raw)=",file=log,sep='\n',append=TRUE)
#   cat(dim(raw),file=log,sep='\n',append=TRUE)
#   
#   # 10/27/2015 - jbucci - check matching gene and protein names (another solution: run check separately)
#   
#   if(!identical(as.vector(c(dimnames(raw.mRNA)[[2]],dimnames(raw.prot)[[2]])),as.vector(dimnames(gannot)[[1]]))){
#     warning("Warning: Gene names in gene annotation file don't match gene names in expression dataset")
#     cat("LOG: Warning: Gene names in gene annotation file don't match gene names in expression dataset",file=log,sep='\n',append=TRUE)
#     warnings.paragraph = paste(warnings.paragraph,"Warning: Gene names in gene annotation file don't match gene names in expression dataset","\n")
#     #cat("document.write('<p>Warning: Gene names in gene annotation file don't match gene names in expresssion dataset</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
#   }
#   
#   # 10/27/2015 - jbucci - create separate matrices for gene and protein data
#   
#   ###### parse gene annotation:
#   ## split data into endog and hk data:
#   e1 = raw.mRNA[,is.element(dimnames(raw.mRNA)[[2]],dimnames(gannot)[[1]][tolower(gannot$Class.Name) %in% c("endogenous", "protein")])]
#   e1 = as.matrix(e1)
#   hk1 = raw.mRNA[,is.element(dimnames(raw.mRNA)[[2]],dimnames(gannot)[[1]][tolower(gannot$Class.Name)=="housekeeping"])]
#   hk1 = as.matrix(hk1)
#   rawdata.mRNA = cbind(e1,hk1)
#   cat("dim(e1):",file=log,sep='\n',append=TRUE)
#   cat(dim(e1),file=log,sep='\n',append=TRUE)
#   cat("dim(hk1):",file=log,sep='\n',append=TRUE)
#   cat(dim(hk1),file=log,sep='\n',append=TRUE)
#   
#   rawdata.protein = as.matrix(raw.prot)
#   
#   ## create the gene annotation matrix:
#   gene.set.column.formatted = gannot[,gene.set.column]
#   gene.set.column.formatted = suppressWarnings(as.vector(replace(gene.set.column.formatted,is.na(gene.set.column.formatted),"")))
#   names(gene.set.column.formatted)=rownames(gannot)
#   gene.set.matrix = annotcolumntomatrix(gene.set.column.formatted)
#   just1gene = colnames(gene.set.matrix)[colSums(gene.set.matrix)<min.gene.set.size]
#   if(length(just1gene)>0)
#   {
#     gene.set.matrix = gene.set.matrix[,setdiff(colnames(gene.set.matrix),just1gene)]
#     print(paste("Warning: the following gene sets hold less than",min.gene.set.size,"genes and will be discarded:"))
#     print(just1gene)
#     warnings.paragraph = paste(warnings.paragraph,"Warning: the following gene sets hold less than",min.gene.set.size,"genes and will be discarded:",paste(just1gene,collapse=", "),"\n")    
#     #warnings.paragraph = paste(warnings.paragraph,"Warning: the following gene sets hold less than",min.gene.set.size,"genes and will be discarded:",cat(just1gene),"\n")    
#     
#   }
#   
#   print ("Finished annotations and data checking")
#   cat("LOG:Finished annotations and data checking",file=log,sep='\n\n',append=TRUE)
#   
#   
#   ### if there are no covariates remaining, stop the analysis:
#   if(ncol(annot)<min.sample.covariate)
#   {
#     cat("document.write('<p>No valid covariates in the analysis.  Please re-run with at least one informative covariate. Categorical covariates must have fewer unique values than observations, and all covariates must have more than 1 unique value.</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE) 
#     stop()    
#   }
#   
#   ### if there are duplicate samples somehow, stop the analysis:
#   samplecor = cor(t(rawdata.mRNA),use="pairwise.complete.obs")
#   diag(samplecor)=0
#   if(max(abs(samplecor))==1)
#   {
#     cat("document.write('<p>There are at least two samples with identical expression profiles.  Remove duplicate RCCs and re-run the analysis.</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE) 
#     stop("There are at least two samples with identical expression profiles.  Remove duplicate RCCs and re-run the analysis.")       
#   }
#   
#   ##### assign colors to all variables:
#   # colors to use:
#   codecols2 = c("chartreuse3","darkgoldenrod2","deepskyblue2","firebrick2","darkorchid1","tan","slateblue3","forestgreen","coral","gray48",
#                 "aquamarine","bisque2","blue3","blueviolet","brown2","burlywood3","darkgoldenrod4","cyan3","cornflowerblue",
#                 "chocolate2","chartreuse1","darkorange","darkorchid4","darkred","darkslateblue","darkturquoise","deeppink1",
#                 "deeppink4","gray7","gold1","dodgerblue1")
#   codecols2 = c(codecols2,colors())
#   contcols = list()
#   contcols[[1]] = c("deepskyblue2","grey","firebrick2")
#   contcols[[2]] = c("forestgreen","grey","darkorange")
#   contcols[[3]] = c("chartreuse","grey","gold1")
#   contcols[[4]] = c("darkorchid1","grey","darkgoldenrod2")
#   contcols[[5]] = c("darkslateblue","grey","chocolate2")
#   for(i in 6:100){contcols[[i]]=contcols[[i-5]]}
#   
#   if(dim(as.data.frame(annot))[2]>0)
#   {
#     # matrix for coloring each observation by each variable:
#     annotcols = matrix("white",dim(as.data.frame(annot))[1],dim(as.data.frame(annot))[2])
#     # list of the unique colors for each annotation
#     annotcols2 = list()
#     dimnames(annotcols)[[1]] = dimnames(annot)[[1]]
#     dimnames(annotcols)[[2]] = dimnames(annot)[[2]]
#     colsused = 0; contcolsused=0
#     for(i in dim(as.data.frame(annot))[2]:1)
#     {
#       # ID type of covariate
#       if(sampleannot.variabletypes[i] == "continuous")
#       {
#         annotcols[,i] = colorRampPalette(contcols[[1+contcolsused]])( 101 )[round((annot[,i]-min(annot[,i],na.rm=T))/(max(annot[,i],na.rm=T)-min(annot[,i],na.rm=T))*100+1,0)]
#         annotcols2[[i]] = contcols[[1+contcolsused]]
#         names(annotcols2[[i]]) = c("Low","Average","High")  
#         names(annotcols2)[i] = dimnames(annot)[[2]][i]
#         contcolsused = contcolsused+1
#       }
#       if(sampleannot.variabletypes[i] == "categorical")
#       {
#         annotcols[,i] = codecols2[(colsused+1):length(codecols2)][annot[,i]]
#         annotcols2[[i]] = codecols2[(colsused+1):length(codecols2)][1:(length(unique(annot[,i]))-1*is.element(NA,annot[,i]))]  #<---- changed to not assign a color to missing elements
#         names(annotcols2)[i] = dimnames(annot)[[2]][i]
#         names(annotcols2[[i]]) = levels(annot[,i])  
#         colsused = length(unique(annot[,i]))-1*is.element(NA,annot[,i])+colsused
#       }
#     }
#     ### draw the color legend: for all variables at once:
#     if(draw.color.legend)
#     {
#       allcolors = alllegends = c()
#       for(i in 1:length(annotcols2))
#       {
#         allcolors = c(allcolors,col=c(NA,annotcols2[[i]]),NA)
#         alllegends = c(alllegends,c(main=names(annotcols2)[i],names(annotcols2[[i]]),NA))
#       }
#       for(r in 1:length(plottypearg)){
#         plottype=plottypearg[r];
#         maxwidth = max(nchar(alllegends))
#         tempfilename = drawplot(filename=paste(path.results,"//color legend",sep=""),
#                                 plottype,width=max(.4,.1+maxwidth*.02),
#                                 height=1+.3*(length(allcolors)>20)+.3*(length(allcolors)>30))
#         tempfilename=gsub(path.results,"results",tempfilename)
#         par(mar=c(0,0,0,0))
#         frame()
#         legend("center",lty=1,lwd=12,col=allcolors,legend=alllegends)
#         dev.off()}   
#     }
#     ### draw the color legend: one for each variable:
#     if(draw.color.legend)
#     {
#       for(i in 1:length(annotcols2))
#       {
#         for(r in 1:length(plottypearg)){
#           plottype=plottypearg[r];
#           maxwidth = max(nchar(alllegends))
#           tempfilename = drawplot(filename=paste(path.results,"//color legend - ",names(annotcols2)[i],sep=""),
#                                   plottype,width=max(.4,.1+maxwidth*.02),
#                                   height=1+.3*(length(annotcols2[[i]])>20)+.3*(length(annotcols2[[i]])>30))
#           tempfilename=gsub(path.results,"results",tempfilename)
#           par(mar=c(0,0,0,0))
#           frame()
#           legend("center",lty=1,lwd=12,col=c(NA,annotcols2[[i]]),legend=c(main=names(annotcols2)[i],names(annotcols2[[i]])))
#           dev.off()}   
#       }
#     }
#   }
#   
#   # 10/27/2015 - jbucci - return separate gene and protein matrices in out list (another solution: merge back into single rawdata matrix)
#   
#   names(sampleannot.variabletypes) = names(sampleannot.referencelevels) = sampleannot.variables
#   out = list(rawdata.mRNA=rawdata.mRNA,rawdata.protein=rawdata.protein,annot=annot,gannot=gannot,gene.set.matrix=gene.set.matrix,annotcols=annotcols,annotcols2=annotcols2,
#              sampleannot.variables=sampleannot.variables,sampleannot.variabletypes=sampleannot.variabletypes,
#              sampleannot.referencelevels=sampleannot.referencelevels,prune=prune,warnings.paragraph=warnings.paragraph)
#   return(out)
# }



############# function to reconcile the arguments in other functions with the annot DF defined by load.and.clean.data:
reconcile.variables.with.annot = function(annot,variables,variabletypes,referencelevels)
{
  ### make variable names legal:
  variables = make.names(variables)
  
  ### remove variables that aren't in annot:
  in.annot = is.element(variables,names(annot))
  if(length(variabletypes)==length(variables)){variabletypes = variabletypes[in.annot]}
  if(length(referencelevels)==length(variables)){referencelevels = referencelevels[in.annot]}
  variables = variables[in.annot]
  
  return(list(variables=variables,variabletypes=variabletypes,referencelevels=referencelevels))  
}



#########
# function to combine a bunch of scores in a trend plot:

trendplot = function(scores,covariate,covariate.name,covariate.type,center=FALSE,scale=FALSE,ylab,lty=NULL,lwd=1)
{
  if(length(lty)==0){lty = rep(1,ncol(scores))}
  # scale scores as appropriate:
  scores = scale(scores,center=center,scale=scale)
  # remove missing data:
  scores = scores[!is.na(covariate),,drop=FALSE]
  covariate = covariate[!is.na(covariate)]
  # make axis label clear:
  if(center&scale){ylab = paste(ylab,"(centered and scaled)")}
  if(!center&scale){ylab = paste(ylab,"(scaled)")}
  if(center&!scale){ylab = paste(ylab,"(centered)")}
  if(covariate.type=="continuous")
  {
    #par(xpd=FALSE)
    layout(cbind(1,2), widths=c(4,2))  # put legend on bottom 1/8th of the chart
    
    plot(0,col=0,xlim=range(covariate),ylim=range(scores),xlab=covariate.name,ylab=ylab)#,bty="L")
    for(i in 1:dim(scores)[2])
    {
      lines(lowess(covariate,scores[,i]),col=codecols2[i],lty=lty[i],lwd=lwd)
    }
    plot.new()
    legend("center",lty=lty,lwd=lwd,legend=dimnames(scores)[[2]],col=codecols2[1:dim(scores)[2]])
  }
  if(covariate.type=="categorical")
  {
    means = matrix(NA,length(levels(covariate)),dim(scores)[2])
    for(i in 1:dim(means)[1])
    {
      means[i,] = apply(scores[covariate==levels(covariate)[i],,drop=FALSE],2,mean)
    }
    layout(cbind(1,2), widths=c(4,2))  # put legend on bottom 1/8th of the chart
    bp = boxplot(scores~covariate,col=0,border=0,xlab="",ylab=ylab,ylim=range(means),las=2)#,bty="L")
    for(i in 1:dim(scores)[2])
    {
      lines(1:length(levels(covariate)),means[,i],col=codecols2[i],lty=lty[i],lwd=lwd)
      points(1:length(levels(covariate)),means[,i])
    }
    plot.new()
    legend("center",lty=lty,lwd=lwd,legend=dimnames(scores)[[2]],col=codecols2[1:dim(scores)[2]])
  }
}



# function to test internet connection for pathview:
testCon <- function(url = "http://www.google.com") {
  
  # test the http capabilities of the current R build
  http <- as.logical(capabilities(what = "http/ftp"))
  if (!http) return(FALSE)
  
  # test connection by trying to read first line at url
  test <- try(suppressWarnings(readLines(url, n = 1)), silent = TRUE)  # silent errors
  
  # return FALSE if test is class 'try-error'
  ifelse(inherits(test, "try-error"), FALSE, TRUE)
}






heatmap.plus = function (x, Rowv = NULL, Colv = if (symm) "Rowv" else NULL, 
                         distfun = dist, hclustfun = hclust, reorderfun = function(d, 
                                                                                   w) reorder(d, w), add.expr, symm = FALSE, revC = identical(Colv, 
                                                                                                                                              "Rowv"), scale = c("row", "column", "none"), na.rm = TRUE, 
                         margins = c(5, 5), ColSideColors, RowSideColors, cexRow = 0.2 + 
                           1/log10(nr), cexCol = 0.2 + 1/log10(nc), labRow = NULL, 
                         labCol = NULL, main = NULL, xlab = NULL, ylab = NULL, keep.dendro = FALSE, 
                         verbose = getOption("verbose"), ...) 
{
  scale <- if (symm && missing(scale)) 
    "none"
  else match.arg(scale)
  if (length(di <- dim(x)) != 2 || !is.numeric(x)) 
    stop("'x' must be a numeric matrix")
  nr <- di[1]
  nc <- di[2]
  #if (nr <= 1 || nc <= 1)                                #<------- new 3-4
  #  stop("'x' must have at least 2 rows and 2 columns")  #<------- new 3-4
  #  if(length(RowSideColors)>0)
  #  {
  #    if(ncol(RowSideColors)==1)
  #    {
  #      RowSideColors = cbind(RowSideColors,RowSideColors)
  #      colnames(RowSideColors)[2] = " "
  #    }
  #  }
  #  if(length(ColSideColors)>0)
  #  {
  #    if(ncol(ColSideColors)==1)
  #    {
  #      ColSideColors = cbind(ColSideColors,ColSideColors)
  #      colnames(ColSideColors)[2] = " "
  #    }
  #  }
  if (!is.numeric(margins) || length(margins) != 2) 
    stop("'margins' must be a numeric vector of length 2")
  doRdend <- !identical(Rowv, NA)
  doCdend <- !identical(Colv, NA)
  if (is.null(Rowv)) 
    Rowv <- rowMeans(x, na.rm = na.rm)
  if (is.null(Colv)) 
    Colv <- colMeans(x, na.rm = na.rm)
  if (doRdend) {
    if (inherits(Rowv, "dendrogram")) 
      ddr <- Rowv
    else {
      hcr <- hclustfun(distfun(x))
      ddr <- as.dendrogram(hcr)
      if (!is.logical(Rowv) || Rowv) 
        ddr <- reorderfun(ddr, Rowv)
    }
    if (nr != length(rowInd <- order.dendrogram(ddr))) 
      stop("row dendrogram ordering gave index of wrong length")
  }
  else rowInd <- 1:nr
  if (doCdend) {
    if (inherits(Colv, "dendrogram")) 
      ddc <- Colv
    else if (identical(Colv, "Rowv")) {
      if (nr != nc) 
        stop("Colv = \"Rowv\" but nrow(x) != ncol(x)")
      ddc <- ddr
    }
    else {
      hcc <- hclustfun(distfun(if (symm) 
        x
        else t(x)))
      ddc <- as.dendrogram(hcc)
      if (!is.logical(Colv) || Colv) 
        ddc <- reorderfun(ddc, Colv)
    }
    if (nc != length(colInd <- order.dendrogram(ddc))) 
      stop("column dendrogram ordering gave index of wrong length")
  }
  else colInd <- 1:nc
  x <- x[rowInd, colInd]
  labRow <- if (is.null(labRow)) 
    if (is.null(rownames(x))) 
      (1:nr)[rowInd]
  else rownames(x)
  else labRow[rowInd]
  labCol <- if (is.null(labCol)) 
    if (is.null(colnames(x))) 
      (1:nc)[colInd]
  else colnames(x)
  else labCol[colInd]
  if (scale == "row") {
    x <- sweep(x, 1, rowMeans(x, na.rm = na.rm))
    sx <- apply(x, 1, sd, na.rm = na.rm)
    x <- sweep(x, 1, sx, "/")
  }
  else if (scale == "column") {
    x <- sweep(x, 2, colMeans(x, na.rm = na.rm))
    sx <- apply(x, 2, sd, na.rm = na.rm)
    x <- sweep(x, 2, sx, "/")
  }
  lmat <- rbind(c(NA, 3), 2:1)
  lwid <- c(if (doRdend) 1 else 0.05, 4)
  lhei <- c((if (doCdend) 1 else 0.05) + if (!is.null(main)) 0.2 else 0, 4)
  if (!missing(ColSideColors)) {
    if (!is.matrix(ColSideColors)) 
      stop("'ColSideColors' must be a matrix")
    if (!is.character(ColSideColors) || dim(ColSideColors)[1] != 
          nc) 
      stop("'ColSideColors' dim()[2] must be of length ncol(x)")
    lmat <- rbind(lmat[1, ] + 1, c(NA, 1), lmat[2, ] + 1)
    #lhei <- c(lhei[1], 0.2, lhei[2])
    # new code to widen the color bars:
    lhei=c(lhei[1], 0.1*dim(ColSideColors)[2], lhei[2])
    
    
  }
  if (!missing(RowSideColors)) {
    if(ncol(RowSideColors)==1)   #<--------- new 5-8
    {
      RowSideColors = cbind(RowSideColors,RowSideColors)
      colnames(RowSideColors)[2] = " "
    }
    if (!is.matrix(RowSideColors)) 
      stop("'RowSideColors' must be a matrix")
    if (!is.character(RowSideColors) || dim(RowSideColors)[1] != 
          nr) 
      stop("'RowSideColors' must be a character vector of length nrow(x)")
    lmat <- cbind(lmat[, 1] + 1, c(rep(NA, nrow(lmat) - 1), 
                                   1), lmat[, 2] + 1)
    #lwid <- c(lwid[1], 0.2, lwid[2])
    # new code to widen the color bars:
    lwid=c(lwid[1], 0.1*dim(RowSideColors)[2], lwid[2])
    
  }
  lmat[is.na(lmat)] <- 0
  if (verbose) {
    cat("layout: widths = ", lwid, ", heights = ", lhei, 
        "; lmat=\n")
    cat(lmat)
  }
  op <- par(no.readonly = TRUE)
  on.exit(par(op))
  layout(lmat, widths = lwid, heights = lhei, respect = FALSE)
  if (!missing(RowSideColors)) {
    par(mar = c(margins[1], 0, 0, 0.5))
    rsc = RowSideColors[rowInd, ,drop=FALSE]  #<----- changed 3-4
    rsc.colors = matrix()
    rsc.names = names(table(rsc))
    rsc.i = 1
    for (rsc.name in rsc.names) {
      rsc.colors[rsc.i] = rsc.name
      rsc[rsc == rsc.name] = rsc.i
      rsc.i = rsc.i + 1
    }
    rsc = matrix(as.numeric(rsc), nrow = dim(rsc)[1])
    image(t(rsc), col = as.vector(rsc.colors), axes = FALSE)
    if (length(colnames(RowSideColors)) > 0) {
      #axis(1, 0:(dim(rsc)[2] - 1)/(dim(rsc)[2] - 1), colnames(RowSideColors),   
      axis(1, at=0:max(dim(rsc)[2] - 1,0)/max((dim(rsc)[2] - 1),.1), colnames(RowSideColors), #<--- changed 4-16          
           las = 2, tick = FALSE)
    }
  }
  if (!missing(ColSideColors)) {
    if(ncol(ColSideColors)==1) #<--------- new 5-8
    {
      ColSideColors = cbind(ColSideColors,ColSideColors)
      colnames(ColSideColors)[2] = " "
    }
    par(mar = c(0.5, 0, 0, margins[2]))
    csc = ColSideColors[colInd, ,drop=FALSE]  #<----- changed 3-4
    csc.colors = matrix()
    csc.names = names(table(csc))
    csc.i = 1
    for (csc.name in csc.names) {
      csc.colors[csc.i] = csc.name
      csc[csc == csc.name] = csc.i
      csc.i = csc.i + 1
    }
    csc = matrix(as.numeric(csc), nrow = dim(csc)[1])
    image(csc, col = as.vector(csc.colors), axes = FALSE)
    if (length(colnames(ColSideColors)) > 0) {
      #axis(2, 0:(dim(csc)[2] - 1)/(dim(csc)[2] - 1), colnames(ColSideColors), 
      axis(2, at=0:max(dim(csc)[2] - 1,1)/max(dim(csc)[2] - 1,1), colnames(ColSideColors), #<--- changed 4-16
           las = 2, tick = FALSE)
    }
  }
  par(mar = c(margins[1], 0, 0, margins[2]))
  if (!symm || scale != "none") {
    x <- t(x)
  }
  if (revC) {
    iy <- nr:1
    ddr <- rev(ddr)
    x <- x[, iy]
  }
  else iy <- 1:nr
  image(1:nc, 1:nr, x, xlim = 0.5 + c(0, nc), ylim = 0.5 + 
          c(0, nr), axes = FALSE, xlab = "", ylab = "", ...)
  axis(1, 1:nc, labels = labCol, las = 2, line = -0.5, tick = 0, 
       cex.axis = cexCol)
  if (!is.null(xlab)) 
    mtext(xlab, side = 1, line = margins[1] - 1.25)
  axis(4, iy, labels = labRow, las = 2, line = -0.5, tick = 0, 
       cex.axis = cexRow)
  if (!is.null(ylab)) 
    mtext(ylab, side = 4, line = margins[2] - 1.25)
  if (!missing(add.expr)) 
    eval(substitute(add.expr))
  par(mar = c(margins[1], 0, 0, 0))
  if (doRdend) 
    plot(ddr, horiz = TRUE, axes = FALSE, yaxs = "i", leaflab = "none")
  else frame()
  par(mar = c(0, 0, if (!is.null(main)) 1 else 0, margins[2]))
  if (doCdend) 
    plot(ddc, axes = FALSE, xaxs = "i", leaflab = "none")
  else if (!is.null(main)) 
    frame()
  if (!is.null(main)) 
    title(main, cex.main = 1.5 * op[["cex.main"]])
  invisible(list(rowInd = rowInd, colInd = colInd, Rowv = if (keep.dendro && 
                                                                doRdend) ddr, Colv = if (keep.dendro && doCdend) ddc))  
}


####### new pairs() function: simple pairs() plot, but cex varies with number of points:
pairs.adaptive.cex = function(dat,...)
{
  if(nrow(dat)>50){adaptive.cex=1}
  if(nrow(dat)<=50){adaptive.cex=2}
  pairs(dat,cex=adaptive.cex,...)
}


####### new heatmap function: heatmap.plus, w my earlier modifications, plus the option to have a list of input matrices of diff analytes
# the fn will draw a series of column-aligned heatmaps in which each analyte's data matrix has clustered rows
heatmap.plus.multipanel = function(Xlist,rowcolorlist,...)
{
  # step 0: pre-processing:
  # if only a matrix is entered, turn it into a list of length 1. 
  if(is.matrix(Xlist)){Xlist = list(Xlist)}
  
  #drop any element which has any dimension zero
  Xlist[sapply(Xlist,function(x)any(dim(x)==0))] <- NULL
  if(is.matrix(rowcolorlist)&!missing(rowcolorlist)){rowcolorlist = list(rowcolorlist)}
  
  # create a single matrix from the column-aligned component matrices:
  bigmat = c()
  for(i in 1:length(Xlist))
  {
    bigmat = rbind(bigmat,Xlist[[i]])
  }
  if(!missing(rowcolorlist))
  {
    bigrowcolors = c()
    for(i in 1:length(rowcolorlist))
    {
      bigrowcolors = rbind(bigrowcolors,rowcolorlist[[i]])
    }  
  }
  
  # step 1: get the dendogram of each matrix in the list, and combine into a reordering of the big matrix (including line breaks)
  reorder.row = c(); 
  for(i in 1:length(Xlist))
  {
    tempmat = Xlist[[i]]
    if(nrow(Xlist[[i]])>1){tempclust = hclust(dist(tempmat))$order}
    if(nrow(Xlist[[i]])==1){tempclust = 1}
    #dends[[i]] = hclust(dist(tempmat))$order
    reorder.row = c(reorder.row,tempclust+length(reorder.row)-i+1)
    # add a separator between the diff matrices:
    if(i<length(Xlist)){reorder.row = c(reorder.row,NA)}
  }
  # step 2: get the dendrogram of the combined data:
  #reorder.column = hclust(dist(t(bigmat)))$order
  reorder.column = 1:ncol(bigmat)
  # matrix to enter into heatmap.plus:
  x = bigmat[reorder.row,reorder.column]
  x = replace(x,is.na(x),-Inf)
  # flip it:
  x = x[nrow(x):1,,drop=FALSE]
  if(!missing(rowcolorlist))
  {
    RowSideColors = bigrowcolors[reorder.row,,drop=FALSE]
    RowSideColors = replace(RowSideColors,is.na(RowSideColors),"white")
    RowSideColors = RowSideColors[nrow(RowSideColors):1,,drop=FALSE]
  }
  # now plot it:
  heatmap.plus.modified(x=x,Rowv=NA,RowSideColors=RowSideColors,...)
}  

### below: heatmap.plus modified to work right when symm=TRUE and to accept only 1 row/column of colors
heatmap.plus.modified = function (x, Rowv = NULL, Colv = if (symm) "Rowv" else NULL, 
                         distfun = dist, hclustfun = hclust, reorderfun = function(d, w) reorder(d, w), 
                         add.expr, symm = FALSE, revC = identical(Colv, "Rowv"), scale = c("row", "column", "none"), na.rm = TRUE, 
                         margins = c(5, 5), ColSideColors, RowSideColors, cexRow = 0.2 + 1/log10(nr), cexCol = 0.2 + 1/log10(nc), 
                         labRow = NULL, labCol = NULL, main = NULL, xlab = NULL, ylab = NULL, keep.dendro = FALSE, 
                         verbose = getOption("verbose"), rowsep=NULL,sepwidth=NULL,sepcolor="white",...) 
{
  scale <- if (symm && missing(scale)) 
    "none"
  else match.arg(scale)
  if (length(di <- dim(x)) != 2 || !is.numeric(x)) 
    stop("'x' must be a numeric matrix")
  nr <- di[1]
  nc <- di[2]
  #if (nr <= 1 || nc <= 1)                                #<------- new 3-4
  #  stop("'x' must have at least 2 rows and 2 columns")  #<------- new 3-4
  #  if(length(RowSideColors)>0)
  #  {
  #    if(ncol(RowSideColors)==1)
  #    {
  #      RowSideColors = cbind(RowSideColors,RowSideColors)
  #      colnames(RowSideColors)[2] = " "
  #    }
  #  }
  #  if(length(ColSideColors)>0)
  #  {
  #    if(ncol(ColSideColors)==1)
  #    {
  #      ColSideColors = cbind(ColSideColors,ColSideColors)
  #      colnames(ColSideColors)[2] = " "
  #    }
  #  }
  if (!is.numeric(margins) || length(margins) != 2) 
    stop("'margins' must be a numeric vector of length 2")
  doRdend <- !identical(Rowv, NA)
  doCdend <- !identical(Colv, NA)
  if (is.null(Rowv)) 
    Rowv <- rowMeans(x, na.rm = na.rm)
  if (is.null(Colv)) 
    Colv <- colMeans(x, na.rm = na.rm)
  if (doRdend) {
    if (inherits(Rowv, "dendrogram")) 
      ddr <- Rowv
    else {
      hcr <- hclustfun(distfun(x))
      ddr <- as.dendrogram(hcr)
      if (!is.logical(Rowv) || Rowv) 
        ddr <- reorderfun(ddr, Rowv)
    }
    if (nr != length(rowInd <- order.dendrogram(ddr))) 
      stop("row dendrogram ordering gave index of wrong length")
  }
  else rowInd <- 1:nr
  if (doCdend) {
    if (inherits(Colv, "dendrogram")) 
      ddc <- Colv
    else if (identical(Colv, "Rowv")) {
      if (nr != nc) 
        stop("Colv = \"Rowv\" but nrow(x) != ncol(x)")
      ddc <- ddr
    }
    else {
      hcc <- hclustfun(distfun(if (symm) 
        x
        else t(x)))
      ddc <- as.dendrogram(hcc)
      if (!is.logical(Colv) || Colv) 
        ddc <- reorderfun(ddc, Colv)
    }
    if (nc != length(colInd <- order.dendrogram(ddc))) 
      stop("column dendrogram ordering gave index of wrong length")
  }
  else colInd <- 1:nc
  x <- x[rowInd, colInd]
  labRow <- if (is.null(labRow)) 
    if (is.null(rownames(x))) 
      (1:nr)[rowInd]
  else rownames(x)
  else labRow[rowInd]
  labCol <- if (is.null(labCol)) 
    if (is.null(colnames(x))) 
      (1:nc)[colInd]
  else colnames(x)
  else labCol[colInd]
  if (scale == "row") {
    x <- sweep(x, 1, rowMeans(x, na.rm = na.rm))
    sx <- apply(x, 1, sd, na.rm = na.rm)
    x <- sweep(x, 1, sx, "/")
  }
  else if (scale == "column") {
    x <- sweep(x, 2, colMeans(x, na.rm = na.rm))
    sx <- apply(x, 2, sd, na.rm = na.rm)
    x <- sweep(x, 2, sx, "/")
  }
  lmat <- rbind(c(NA, 3), 2:1)
  lwid <- c(if (doRdend) 1 else 0.05, 4)
  lhei <- c((if (doCdend) 1 else 0.05) + if (!is.null(main)) 0.2 else 0, 4)
  if (!missing(ColSideColors)) {
    if (!is.matrix(ColSideColors)) 
      stop("'ColSideColors' must be a matrix")
    if (!is.character(ColSideColors) || dim(ColSideColors)[1] != 
          nc) 
      stop("'ColSideColors' dim()[2] must be of length ncol(x)")
    lmat <- rbind(lmat[1, ] + 1, c(NA, 1), lmat[2, ] + 1)
    #lhei <- c(lhei[1], 0.2, lhei[2])
    # new code to widen the color bars:
    lhei=c(lhei[1], 0.1*dim(ColSideColors)[2], lhei[2])
    
    
  }
  if (!missing(RowSideColors)) {
    if(ncol(RowSideColors)==1)   #<--------- new 5-8
    {
      RowSideColors = cbind(RowSideColors,RowSideColors)
      colnames(RowSideColors)[2] = " "
    }
    if (!is.matrix(RowSideColors)) 
      stop("'RowSideColors' must be a matrix")
    if (!is.character(RowSideColors) || dim(RowSideColors)[1] != 
          nr) 
      stop("'RowSideColors' must be a character vector of length nrow(x)")
    lmat <- cbind(lmat[, 1] + 1, c(rep(NA, nrow(lmat) - 1), 
                                   1), lmat[, 2] + 1)
    #lwid <- c(lwid[1], 0.2, lwid[2])
    # new code to widen the color bars:
    lwid=c(lwid[1], 0.1*dim(RowSideColors)[2], lwid[2])
    
  }
  lmat[is.na(lmat)] <- 0
  if (verbose) {
    cat("layout: widths = ", lwid, ", heights = ", lhei, 
        "; lmat=\n")
    cat(lmat)
  }
  op <- par(no.readonly = TRUE)
  on.exit(par(op))
  layout(lmat, widths = lwid, heights = lhei, respect = FALSE)
  if (!missing(RowSideColors)) {
    par(mar = c(margins[1], 0, 0, 0.5))
    rsc = RowSideColors[rowInd, ,drop=FALSE]  #<----- changed 3-4
    rsc.colors = matrix()
    rsc.names = names(table(rsc))
    rsc.i = 1
    for (rsc.name in rsc.names) {
      rsc.colors[rsc.i] = rsc.name
      rsc[rsc == rsc.name] = rsc.i
      rsc.i = rsc.i + 1
    }
    rsc = matrix(as.numeric(rsc), nrow = dim(rsc)[1])
    image(t(rsc), col = as.vector(rsc.colors), axes = FALSE)
    if (length(colnames(RowSideColors)) > 0) {
      #axis(1, 0:(dim(rsc)[2] - 1)/(dim(rsc)[2] - 1), colnames(RowSideColors),   
      axis(1, at=0:max(dim(rsc)[2] - 1,0)/max((dim(rsc)[2] - 1),.1), colnames(RowSideColors), #<--- changed 4-16          
           las = 2, tick = FALSE)
    }
  }
  if (!missing(ColSideColors)) {
    if(ncol(ColSideColors)==1) #<--------- new 5-8
    {
      ColSideColors = cbind(ColSideColors,ColSideColors)
      colnames(ColSideColors)[2] = " "
    }
    par(mar = c(0.5, 0, 0, margins[2]))
    csc = ColSideColors[colInd, ,drop=FALSE]  #<----- changed 3-4
    csc.colors = matrix()
    csc.names = names(table(csc))
    csc.i = 1
    for (csc.name in csc.names) {
      csc.colors[csc.i] = csc.name
      csc[csc == csc.name] = csc.i
      csc.i = csc.i + 1
    }
    csc = matrix(as.numeric(csc), nrow = dim(csc)[1])
    image(csc, col = as.vector(csc.colors), axes = FALSE)
    if (length(colnames(ColSideColors)) > 0) {
      #axis(2, 0:(dim(csc)[2] - 1)/(dim(csc)[2] - 1), colnames(ColSideColors), 
      axis(2, at=0:max(dim(csc)[2] - 1,1)/max(dim(csc)[2] - 1,1), colnames(ColSideColors), #<--- changed 4-16
           las = 2, tick = FALSE)
    }
  }
  
  
  par(mar = c(margins[1], 0, 0, margins[2]))
  if (!symm || scale != "none") {
    x <- t(x)
  }
  if (revC) {
    iy <- nr:1
    ddr <- rev(ddr)
    x <- x[, iy]
  }
  else iy <- 1:nr
  image(1:nc, 1:nr, x, xlim = 0.5 + c(0, nc), ylim = 0.5 + 
          c(0, nr), axes = FALSE, xlab = "", ylab = "", ...)
  axis(1, 1:nc, labels = labCol, las = 2, line = -0.5, tick = 0, 
       cex.axis = cexCol)
  if (!is.null(xlab)) 
    mtext(xlab, side = 1, line = margins[1] - 1.25)
  axis(4, iy, labels = labRow, las = 2, line = -0.5, tick = 0, 
       cex.axis = cexRow)
  if (!is.null(ylab)) 
    mtext(ylab, side = 4, line = margins[2] - 1.25)
  if (!missing(add.expr)) 
    eval(substitute(add.expr))
  par(mar = c(margins[1], 0, 0, 0))
  if (doRdend) 
    plot(ddr, horiz = TRUE, axes = FALSE, yaxs = "i", leaflab = "none")
  else frame()
  par(mar = c(0, 0, if (!is.null(main)) 1 else 0, margins[2]))
  if (doCdend) 
    plot(ddc, axes = FALSE, xaxs = "i", leaflab = "none")
  else if (!is.null(main)) 
    frame()
  if (!is.null(main)) 
    title(main, cex.main = 1.5 * op[["cex.main"]])
  invisible(list(rowInd = rowInd, colInd = colInd, Rowv = if (keep.dendro && 
                                                                doRdend) ddr, Colv = if (keep.dendro && doCdend) ddc))  
  
}



#### final heatmap function:
heatmap.3 <- function(x,
                      Rowv = TRUE, Colv = if (symm) "Rowv" else TRUE,
                      distfun = dist,
                      hclustfun = hclust,
                      dendrogram = c("both","row", "column", "none"),
                      symm = FALSE,
                      scale = c("none","row", "column"),
                      na.rm = TRUE,
                      revC = identical(Colv,"Rowv"),
                      add.expr,
                      breaks,
                      symbreaks = max(x < 0, na.rm = TRUE) || scale != "none",
                      col = "heat.colors",
                      colsep,
                      rowsep,
                      sepcolor = "white",
                      sepwidth = c(0.05, 0.05),
                      cellnote,
                      notecex = 1,
                      notecol = "cyan",
                      na.color = par("bg"),
                      trace = c("none", "column","row", "both"),
                      tracecol = "cyan",
                      hline = median(breaks),
                      vline = median(breaks),
                      linecol = tracecol,
                      margins = c(5,5),
                      ColSideColors,
                      RowSideColors,
                      side.height.fraction=0.3,
                      cexRow = 0.2 + 1/log10(nr),
                      cexCol = 0.2 + 1/log10(nc),
                      labRow = NULL,
                      labCol = NULL,
                      key = TRUE,
                      keysize = 1.5,
                      density.info = c("none", "histogram", "density"),
                      denscol = tracecol,
                      symkey = max(x < 0, na.rm = TRUE) || symbreaks,
                      densadj = 0.25,
                      main = NULL,
                      xlab = NULL,
                      ylab = NULL,
                      lmat = NULL,
                      lhei = NULL,
                      lwid = NULL,
                      NumColSideColors = 1,
                      NumRowSideColors = 1,
                      KeyValueName="Value",...){
  
  invalid <- function (x) {
    if (missing(x) || is.null(x) || length(x) == 0)
      return(TRUE)
    if (is.list(x))
      return(all(sapply(x, invalid)))
    else if (is.vector(x))
      return(all(is.na(x)))
    else return(FALSE)
  }
  
  x <- as.matrix(x)
  scale01 <- function(x, low = min(x), high = max(x)) {
    x <- (x - low)/(high - low)
    x
  }
  retval <- list()
  scale <- if (symm && missing(scale))
    "none"
  else match.arg(scale)
  dendrogram <- match.arg(dendrogram)
  trace <- match.arg(trace)
  density.info <- match.arg(density.info)
  if (length(col) == 1 && is.character(col))
    col <- get(col, mode = "function")
  if (!missing(breaks) && (scale != "none"))
    warning("Using scale=\"row\" or scale=\"column\" when breaks are",
            "specified can produce unpredictable results.", "Please consider using only one or the other.")
  if (is.null(Rowv) || is.na(Rowv))
    Rowv <- FALSE
  if (is.null(Colv) || is.na(Colv))
    Colv <- FALSE
  else if (Colv == "Rowv" && !isTRUE(Rowv))
    Colv <- FALSE
  if (length(di <- dim(x)) != 2 || !is.numeric(x))
    stop("`x' must be a numeric matrix")
  nr <- di[1]
  nc <- di[2]
  if (nr <= 1 || nc <= 1)
    stop("`x' must have at least 2 rows and 2 columns")
  if (!is.numeric(margins) || length(margins) != 2)
    stop("`margins' must be a numeric vector of length 2")
  if (missing(cellnote))
    cellnote <- matrix("", ncol = ncol(x), nrow = nrow(x))
  if (!inherits(Rowv, "dendrogram")) {
    if (((!isTRUE(Rowv)) || (is.null(Rowv))) && (dendrogram %in%
                                                   c("both", "row"))) {
      if (is.logical(Colv) && (Colv))
        dendrogram <- "column"
      else dedrogram <- "none"
      warning("Discrepancy: Rowv is FALSE, while dendrogram is `",
              dendrogram, "'. Omitting row dendogram.")
    }
  }
  if (!inherits(Colv, "dendrogram")) {
    if (((!isTRUE(Colv)) || (is.null(Colv))) && (dendrogram %in%
                                                   c("both", "column"))) {
      if (is.logical(Rowv) && (Rowv))
        dendrogram <- "row"
      else dendrogram <- "none"
      warning("Discrepancy: Colv is FALSE, while dendrogram is `",
              dendrogram, "'. Omitting column dendogram.")
    }
  }
  if (inherits(Rowv, "dendrogram")) {
    ddr <- Rowv
    rowInd <- order.dendrogram(ddr)
  }
  else if (is.integer(Rowv)) {
    hcr <- hclustfun(distfun(x))
    ddr <- as.dendrogram(hcr)
    ddr <- reorder(ddr, Rowv)
    rowInd <- order.dendrogram(ddr)
    if (nr != length(rowInd))
      stop("row dendrogram ordering gave index of wrong length")
  }
  else if (isTRUE(Rowv)) {
    Rowv <- rowMeans(x, na.rm = na.rm)
    hcr <- hclustfun(distfun(x))
    ddr <- as.dendrogram(hcr)
    ddr <- reorder(ddr, Rowv)
    rowInd <- order.dendrogram(ddr)
    if (nr != length(rowInd))
      stop("row dendrogram ordering gave index of wrong length")
  }
  else {
    rowInd <- nr:1
  }
  if (inherits(Colv, "dendrogram")) {
    ddc <- Colv
    colInd <- order.dendrogram(ddc)
  }
  else if (identical(Colv, "Rowv")) {
    if (nr != nc)
      stop("Colv = \"Rowv\" but nrow(x) != ncol(x)")
    if (exists("ddr")) {
      ddc <- ddr
      colInd <- order.dendrogram(ddc)
    }
    else colInd <- rowInd
  }
  else if (is.integer(Colv)) {
    hcc <- hclustfun(distfun(if (symm)
      x
      else t(x)))
    ddc <- as.dendrogram(hcc)
    ddc <- reorder(ddc, Colv)
    colInd <- order.dendrogram(ddc)
    if (nc != length(colInd))
      stop("column dendrogram ordering gave index of wrong length")
  }
  else if (isTRUE(Colv)) {
    Colv <- colMeans(x, na.rm = na.rm)
    hcc <- hclustfun(distfun(if (symm)
      x
      else t(x)))
    ddc <- as.dendrogram(hcc)
    ddc <- reorder(ddc, Colv)
    colInd <- order.dendrogram(ddc)
    if (nc != length(colInd))
      stop("column dendrogram ordering gave index of wrong length")
  }
  else {
    colInd <- 1:nc
  }
  retval$rowInd <- rowInd
  retval$colInd <- colInd
  retval$call <- match.call()
  x <- x[rowInd, colInd]
  x.unscaled <- x
  cellnote <- cellnote[rowInd, colInd]
  if (is.null(labRow))
    labRow <- if (is.null(rownames(x)))
      (1:nr)[rowInd]
  else rownames(x)
  else labRow <- labRow[rowInd]
  if (is.null(labCol))
    labCol <- if (is.null(colnames(x)))
      (1:nc)[colInd]
  else colnames(x)
  else labCol <- labCol[colInd]
  if (scale == "row") {
    retval$rowMeans <- rm <- rowMeans(x, na.rm = na.rm)
    x <- sweep(x, 1, rm)
    retval$rowSDs <- sx <- apply(x, 1, sd, na.rm = na.rm)
    x <- sweep(x, 1, sx, "/")
  }
  else if (scale == "column") {
    retval$colMeans <- rm <- colMeans(x, na.rm = na.rm)
    x <- sweep(x, 2, rm)
    retval$colSDs <- sx <- apply(x, 2, sd, na.rm = na.rm)
    x <- sweep(x, 2, sx, "/")
  }
  if (missing(breaks) || is.null(breaks) || length(breaks) < 1) {
    if (missing(col) || is.function(col))
      breaks <- 16
    else breaks <- length(col) + 1
  }
  if (length(breaks) == 1) {
    if (!symbreaks)
      breaks <- seq(min(x, na.rm = na.rm), max(x, na.rm = na.rm),
                    length = breaks)
    else {
      extreme <- max(abs(x), na.rm = TRUE)
      breaks <- seq(-extreme, extreme, length = breaks)
    }
  }
  nbr <- length(breaks)
  ncol <- length(breaks) - 1
  if (class(col) == "function")
    col <- col(ncol)
  min.breaks <- min(breaks)
  max.breaks <- max(breaks)
  x[x < min.breaks] <- min.breaks
  x[x > max.breaks] <- max.breaks
  if (missing(lhei) || is.null(lhei))
    lhei <- c(keysize, 4)
  if (missing(lwid) || is.null(lwid))
    lwid <- c(keysize, 4)
  if (missing(lmat) || is.null(lmat)) {
    lmat <- rbind(4:3, 2:1)
    
    if (!missing(ColSideColors)) {
      #if (!is.matrix(ColSideColors))
      #stop("'ColSideColors' must be a matrix")
      if (!is.character(ColSideColors) || nrow(ColSideColors) != nc)
        stop("'ColSideColors' must be a matrix of nrow(x) rows")
      lmat <- rbind(lmat[1, ] + 1, c(NA, 1), lmat[2, ] + 1)
      #lhei <- c(lhei[1], 0.2, lhei[2])
      lhei=c(lhei[1], side.height.fraction*NumColSideColors, lhei[2])
    }
    
    if (!missing(RowSideColors)) 
    {
      if(nrow(RowSideColors)==1)   #<--------- new 5-8
      {
        RowSideColors = rbind(RowSideColors,RowSideColors)
        rownames(RowSideColors)[2] = " "
      }
      #if (!is.matrix(RowSideColors))
      #stop("'RowSideColors' must be a matrix")
      if (!is.character(RowSideColors) || ncol(RowSideColors) != nr)
        stop("'RowSideColors' must be a matrix of ncol(x) columns")
      lmat <- cbind(lmat[, 1] + 1, c(rep(NA, nrow(lmat) - 1), 1), lmat[,2] + 1)
      #lwid <- c(lwid[1], 0.2, lwid[2])
      lwid <- c(lwid[1], side.height.fraction*NumRowSideColors, lwid[2])
    }
    lmat[is.na(lmat)] <- 0
  }
  
  if (length(lhei) != nrow(lmat))
    stop("lhei must have length = nrow(lmat) = ", nrow(lmat))
  if (length(lwid) != ncol(lmat))
    stop("lwid must have length = ncol(lmat) =", ncol(lmat))
  op <- par(no.readonly = TRUE)
  on.exit(par(op))
  
  layout(lmat, widths = lwid, heights = lhei, respect = FALSE)
  
  if (!missing(RowSideColors)) {
    if (!is.matrix(RowSideColors)){
      par(mar = c(margins[1], 0, 0, 0.5))
      image(rbind(1:nr), col = RowSideColors[rowInd], axes = FALSE)
    } else {
      par(mar = c(margins[1], 0, 0, 0.5))
      rsc = t(RowSideColors[,rowInd, drop=F])
      rsc.colors = matrix()
      rsc.names = names(table(rsc))
      rsc.i = 1
      for (rsc.name in rsc.names) {
        rsc.colors[rsc.i] = rsc.name
        rsc[rsc == rsc.name] = rsc.i
        rsc.i = rsc.i + 1
      }
      rsc = matrix(as.numeric(rsc), nrow = dim(rsc)[1])
      image(t(rsc), col = as.vector(rsc.colors), axes = FALSE)
      if (length(rownames(RowSideColors)) > 0) {
        axis(1, 0:(dim(rsc)[2] - 1)/(dim(rsc)[2] - 1), rownames(RowSideColors), las = 2, tick = FALSE)
      }
    }
  }
  
  if (!missing(ColSideColors)) 
  {
    if(ncol(ColSideColors)==1) #<--------- new 5-8
    {
      ColSideColors = cbind(ColSideColors,ColSideColors)
      colnames(ColSideColors)[2] = " "
    }
    
    if (!is.matrix(ColSideColors)){
      par(mar = c(0.5, 0, 0, margins[2]))
      image(cbind(1:nc), col = ColSideColors[colInd], axes = FALSE)
    } else {
      par(mar = c(0.5, 0, 0, margins[2]))
      csc = ColSideColors[colInd, , drop=F]
      csc.colors = matrix()
      csc.names = names(table(csc))
      csc.i = 1
      for (csc.name in csc.names) {
        csc.colors[csc.i] = csc.name
        csc[csc == csc.name] = csc.i
        csc.i = csc.i + 1
      }
      csc = matrix(as.numeric(csc), nrow = dim(csc)[1])
      image(csc, col = as.vector(csc.colors), axes = FALSE)
      if (length(colnames(ColSideColors)) > 0) {
        axis(2, 0:(dim(csc)[2] - 1)/max(1,(dim(csc)[2] - 1)), colnames(ColSideColors), las = 2, tick = FALSE)
      }
    }
  }
  
  par(mar = c(margins[1], 0, 0, margins[2]))
  x <- t(x)
  cellnote <- t(cellnote)
  if (revC) {
    iy <- nr:1
    if (exists("ddr"))
      ddr <- rev(ddr)
    x <- x[, iy]
    cellnote <- cellnote[, iy]
  }
  else iy <- 1:nr
  image(1:nc, 1:nr, x, xlim = 0.5 + c(0, nc), ylim = 0.5 + c(0, nr), axes = FALSE, xlab = "", ylab = "", col = col, breaks = breaks, ...)
  retval$carpet <- x
  if (exists("ddr"))
    retval$rowDendrogram <- ddr
  if (exists("ddc"))
    retval$colDendrogram <- ddc
  retval$breaks <- breaks
  retval$col <- col
  if (!invalid(na.color) & any(is.na(x))) { # load library(gplots)
    mmat <- ifelse(is.na(x), 1, NA)
    image(1:nc, 1:nr, mmat, axes = FALSE, xlab = "", ylab = "",
          col = na.color, add = TRUE)
  }
  axis(1, 1:nc, labels = labCol, las = 2, line = -0.5, tick = 0,
       cex.axis = cexCol)
  if (!is.null(xlab))
    mtext(xlab, side = 1, line = margins[1] - 1.25)
  axis(4, iy, labels = labRow, las = 2, line = -0.5, tick = 0,
       cex.axis = cexRow)
  if (!is.null(ylab))
    mtext(ylab, side = 4, line = margins[2] - 1.25)
  if (!missing(add.expr))
    eval(substitute(add.expr))
  if (!missing(colsep))
    for (csep in colsep) rect(xleft = csep + 0.5, ybottom = rep(0, length(csep)), xright = csep + 0.5 + sepwidth[1], ytop = rep(ncol(x) + 1, csep), lty = 1, lwd = 1, col = sepcolor, border = sepcolor)
  if (!missing(rowsep))
    for (rsep in rowsep) rect(xleft = 0, ybottom = (ncol(x) + 1 - rsep) - 0.5, xright = nrow(x) + 1, ytop = (ncol(x) + 1 - rsep) - 0.5 - sepwidth[2], lty = 1, lwd = 1, col = sepcolor, border = sepcolor)
  min.scale <- min(breaks)
  max.scale <- max(breaks)
  x.scaled <- scale01(t(x), min.scale, max.scale)
  if (trace %in% c("both", "column")) {
    retval$vline <- vline
    vline.vals <- scale01(vline, min.scale, max.scale)
    for (i in colInd) {
      if (!is.null(vline)) {
        abline(v = i - 0.5 + vline.vals, col = linecol,
               lty = 2)
      }
      xv <- rep(i, nrow(x.scaled)) + x.scaled[, i] - 0.5
      xv <- c(xv[1], xv)
      yv <- 1:length(xv) - 0.5
      lines(x = xv, y = yv, lwd = 1, col = tracecol, type = "s")
    }
  }
  if (trace %in% c("both", "row")) {
    retval$hline <- hline
    hline.vals <- scale01(hline, min.scale, max.scale)
    for (i in rowInd) {
      if (!is.null(hline)) {
        abline(h = i + hline, col = linecol, lty = 2)
      }
      yv <- rep(i, ncol(x.scaled)) + x.scaled[i, ] - 0.5
      yv <- rev(c(yv[1], yv))
      xv <- length(yv):1 - 0.5
      lines(x = xv, y = yv, lwd = 1, col = tracecol, type = "s")
    }
  }
  if (!missing(cellnote))
    text(x = c(row(cellnote)), y = c(col(cellnote)), labels = c(cellnote),
         col = notecol, cex = notecex)
  par(mar = c(margins[1], 0, 0, 0))
  if (dendrogram %in% c("both", "row")) {
    plot(ddr, horiz = TRUE, axes = FALSE, yaxs = "i", leaflab = "none")
  }
  else plot.new()
  par(mar = c(0, 0, if (!is.null(main)) 5 else 0, margins[2]))
  if (dendrogram %in% c("both", "column")) {
    plot(ddc, axes = FALSE, xaxs = "i", leaflab = "none")
  }
  else plot.new()
  if (!is.null(main))
    title(main, cex.main = 1.5 * op[["cex.main"]])
  if (key) {
    par(mar = c(5, 4, 2, 1), cex = 0.75)
    tmpbreaks <- breaks
    if (symkey) {
      max.raw <- max(abs(c(x, breaks)), na.rm = TRUE)
      min.raw <- -max.raw
      tmpbreaks[1] <- -max(abs(x), na.rm = TRUE)
      tmpbreaks[length(tmpbreaks)] <- max(abs(x), na.rm = TRUE)
    }
    else {
      min.raw <- min(x, na.rm = TRUE)
      max.raw <- max(x, na.rm = TRUE)
    }
    
    z <- seq(min.raw, max.raw, length = length(col))
    image(z = matrix(z, ncol = 1), col = col, breaks = tmpbreaks,
          xaxt = "n", yaxt = "n")
    par(usr = c(0, 1, 0, 1))
    lv <- pretty(breaks)
    xv <- scale01(as.numeric(lv), min.raw, max.raw)
    axis(1, at = xv, labels = lv)
    if (scale == "row")
      mtext(side = 1, "Row Z-Score", line = 2)
    else if (scale == "column")
      mtext(side = 1, "Column Z-Score", line = 2)
    else mtext(side = 1, KeyValueName, line = 2)
    if (density.info == "density") {
      dens <- density(x, adjust = densadj, na.rm = TRUE)
      omit <- dens$x < min(breaks) | dens$x > max(breaks)
      dens$x <- dens$x[-omit]
      dens$y <- dens$y[-omit]
      dens$x <- scale01(dens$x, min.raw, max.raw)
      lines(dens$x, dens$y/max(dens$y) * 0.95, col = denscol,
            lwd = 1)
      axis(2, at = pretty(dens$y)/max(dens$y) * 0.95, pretty(dens$y))
      title("Color Key\nand Density Plot")
      par(cex = 0.5)
      mtext(side = 2, "Density", line = 2)
    }
    else if (density.info == "histogram") {
      h <- hist(x, plot = FALSE, breaks = breaks)
      hx <- scale01(breaks, min.raw, max.raw)
      hy <- c(h$counts, h$counts[length(h$counts)])
      lines(hx, hy/max(hy) * 0.95, lwd = 1, type = "s",
            col = denscol)
      axis(2, at = pretty(hy)/max(hy) * 0.95, pretty(hy))
      title("Color Key\nand Histogram")
      par(cex = 0.5)
      mtext(side = 2, "Count", line = 2)
    }
    else title("Color Key")
  }
  else plot.new()
  retval$colorTable <- data.frame(low = retval$breaks[-length(retval$breaks)],
                                  high = retval$breaks[-1], color = retval$col)
  invisible(retval)
}

#'This function visualizes a matrix or data frame
#'@x a matrix or dataframe
#'@show.val logical. If TRUE it prints the value of each cell
#'@frmt.val if show.val is TRUE this determins the formatting of the text
#'@keep.order logical. If TRUE, the order of columns and rows remain intact
#'@low.col a color as chracter string. The low end of the color heatmap eg. "green"
#'@high.col a color as character string. The high endo the color gradient eg. "red"
#'@xlabel a character string. When specified it is labels the colomn names (not the column names themselves)
#'@ylabel a character string. When specified it is labels the row names (not the row names themselves)

visualize.matrix <- function(x,show.val = FALSE ,frmt.val = "%1.2f",keep.order = T, low.col = NULL, high.col = NULL,xlabel = NULL, ylabel = NULL){
  if(is.data.frame(x))
    x <- as.matrix(x)
  
  require(reshape)
  dat <- melt(t(as.matrix(as.data.frame.matrix(x))))
  dat$label <- sprintf(fmt = eval(frmt.val),dat$value)
  
  if(keep.order){
    dat$X1 <- factor(dat$X1,levels = colnames(x))
    dat$X2 <- factor(dat$X2,levels = rownames(x))
  }
  
  require(ggplot2)
  
  p <- ggplot(data =  dat, aes(x = X1, y = X2)) +
    geom_tile(aes(fill = value), colour = "white") + xlab(xlabel) + ylab(ylabel) + 
    theme(axis.text.x = element_text(angle = 90, hjust = 1))
  
  if(show.val)
    p <- p + geom_text(aes(label = label), vjust = 1) 
  
  if(!is.null(low.col) & !is.null(high.col))
    p <- p + scale_fill_gradient(low = low.col, high = high.col)
  
    
  return(p)
}
